public abstract class HackerThread extends Thread {
    // The vault the hacker is trying to break into
    protected final Vault vault;
    // The hacker's name
    protected final String hackerName;

    public HackerThread(Vault vault, String hackerName) {
        this.vault = vault;
        this.hackerName = hackerName;
        // 3. Set Maximum Priority for hackers (Required)
        this.setPriority(Thread.MAX_PRIORITY);
    }

    // Abstract function to force child classes to implement the guessing logic
    @Override
    public abstract void run();

    // Shared function called when the hacker wins
    protected void success(int correctPassword) {
        // 4. Shared success behavior
        System.out.println("\n-------------------------------------------------");
        System.out.println(hackerName + " WON! Cracked the Vault.");
        System.out.println("The password was: " + correctPassword);
        System.out.println("-------------------------------------------------");

        // 5. Terminate the entire program (Required)
        System.exit(0);
    }
}