public class AscendingHackerThread extends HackerThread {

    public AscendingHackerThread(Vault vault) {
        // Pass the hacker's name to the parent class
        super(vault, "Ascending Hacker");
    }

    @Override
    public void run() {
        System.out.println(hackerName + " started searching from 0 upwards.");

        // Search from 0 up to 9999
        for (int guess = 0; guess <= 9999; guess++) {
            if (vault.isCorrectPassword(guess)) {
                // If successful, terminate the program via the success function in the parent class
                success(guess);
            }
        }
        // If the police win first, this part won't be executed due to System.exit(0)
    }
}