public class PoliceThread extends Thread {

    public PoliceThread() {
        // 6. Setting a lower priority to give hackers (MAX_PRIORITY) a slight advantage.
        this.setPriority(Thread.MIN_PRIORITY);
    }

    @Override
    public void run() {
        System.out.println("\nPolice are on their way: 10 seconds remaining.");

        // Countdown from 10 to 0 (Required)
        for (int countdown = 10; countdown >= 0; countdown--) {
            try {
                // 7. Print countdown every second
                if (countdown > 0) {
                    System.out.println("Countdown: " + countdown + "...");
                    // Wait for one second
                    Thread.sleep(1000);
                }
            } catch (InterruptedException e) {
                // 8. Handle Interruption (if another thread tries to stop the police thread)
                System.out.println("Police interrupted! But they keep going.");
            }
        }

        // 9. When the countdown reaches 0 (Time is up)
        System.out.println("\n*************************************************");
        System.out.println("Game over for you hackers! The Police arrived.");
        System.out.println("*************************************************");

        // 10. Terminate the entire program (Required)
        System.exit(0);
    }
}