public class DescendingHackerThread extends HackerThread {

    public DescendingHackerThread(Vault vault) {
        super(vault, "Descending Hacker");
    }

    @Override
    public void run() {
        System.out.println(hackerName + " started searching from 9999 downwards.");

        // Search from 9999 down to 0
        for (int guess = 9999; guess >= 0; guess--) {
            if (vault.isCorrectPassword(guess)) {
                // If successful, terminate the program
                success(guess);
            }
        }
    }
}