from sqlalchemy import Column, String, Boolean, DateTime, LargeBinary, ForeignKey, Text
from sqlalchemy.sql import func
from sqlalchemy.orm import relationship
from src.infrastructure.persistence.models.base import Base, TimestampMixin
import uuid

class UserModel(Base, TimestampMixin):
    __tablename__ = 'users'
    
    id = Column(String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    email = Column(String(255), unique=True, nullable=False)
    password_hash = Column(String(255), nullable=False)
    is_active = Column(Boolean, default=True)
    last_login = Column(DateTime(timezone=True), nullable=True)

    # Relationships
    chart_images = relationship("ChartImageModel", back_populates="user")
    conversations = relationship("ConversationModel", back_populates="user")
