from sqlalchemy import Column, String, ForeignKey, LargeBinary
from sqlalchemy.orm import relationship
from src.infrastructure.persistence.models.base import Base, TimestampMixin
import uuid


class ChartImageModel(Base, TimestampMixin):
    __tablename__ = 'chart_images'
    
    id = Column(String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    user_id = Column(String(36), ForeignKey('users.id'), nullable=False)
    file_path = Column(String(512), nullable=True)  # File path for filesystem storage
    image_data = Column(LargeBinary, nullable=True)  # Direct image data for one-time analysis
    thumbnail_path = Column(String(512), nullable=True)
    
    # Relationships
    user = relationship("UserModel", back_populates="chart_images")
    analysis = relationship("ChartAnalysisModel", back_populates="chart_image")
    # Chart references are now handled through ConversationChartReferenceModel
