
from sqlalchemy import Column, String, DateTime
from sqlalchemy.sql import func
from src.infrastructure.persistence.models.base import Base
import uuid


class BlacklistedTokenModel(Base):
    __tablename__ = 'blacklisted_tokens'
    
    id = Column(String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    token = Column(String(512), unique=True, nullable=False)
    expires_at = Column(DateTime(timezone=True), nullable=False)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
