from sqlalchemy import Column, String, Text, ForeignKey, JSON
from sqlalchemy.orm import relationship
from src.infrastructure.persistence.models.base import Base, TimestampMixin
import uuid

class ChartAnalysisModel(Base, TimestampMixin):
    __tablename__ = 'chart_analysis'
    
    id = Column(String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    chart_image_id = Column(String(36), ForeignKey('chart_images.id'), nullable=False)
    question = Column(Text, nullable=False)
    answer = Column(Text, nullable=False)
    #metadata = Column(JSON)  # Added for additional analysis data
    
    # Relationship
    chart_image = relationship("ChartImageModel", back_populates="analysis")
