# src/domain/ports/repositories/token_repository.py
from datetime import datetime
from abc import ABC, abstractmethod

class TokenRepositoryPort(ABC):
    @abstractmethod
    async def add_to_blacklist(self, token: str, expires_at: datetime) -> None:
        pass
    
    @abstractmethod
    async def is_blacklisted(self, token: str) -> bool:
        pass