from src.domain.ports.repositories.analysis_repository import AnalysisRepositoryPort
from src.domain.entities.chart_analysis import ChartAnalysis
from typing import List

class GetAnalysisHistoryUseCase:
    def __init__(self, analysis_repo: AnalysisRepositoryPort):
        self._analysis_repo = analysis_repo

    def execute(self, user_id: str, limit: int = 50) -> List[ChartAnalysis]:
        """Get analysis history for a user"""
        return self._analysis_repo.get_analyses_by_user_id(user_id, limit) 