from pydantic import BaseModel
from typing import List, Optional

class CreateConversationRequestDTO(BaseModel):
    title: str
    initial_chart_image_id: Optional[str] = None  # Optional initial chart

class SendMessageRequestDTO(BaseModel):
    message: str
    chart_image_id: Optional[str] = None  # Optional chart to include with message

class ConversationResponseDTO(BaseModel):
    id: str
    title: str
    created_at: str
    updated_at: str
    message_count: int
    chart_count: int

class MessageContentDTO(BaseModel):
    text: Optional[str] = None
    chart_image_id: Optional[str] = None

class MessageResponseDTO(BaseModel):
    id: str
    message_type: str
    content: MessageContentDTO
    timestamp: str
    sender_id: str

class ConversationDetailResponseDTO(BaseModel):
    id: str
    title: str
    created_at: str
    updated_at: str
    messages: List[MessageResponseDTO]
    referenced_charts: List[str] 