from abc import ABC, abstractmethod
from uuid import UUID
from typing import Tuple, Optional
from datetime import datetime

class FileStoragePort(ABC):
    """Abstract base class for file storage operations"""
    
    @abstractmethod
    async def save_chart_image(
        self, 
        user_id: UUID, 
        image_data: bytes, 
        content_type: str
    ) -> str:
        """Save chart image to storage and return file path"""
        pass
    
    @abstractmethod
    async def get_chart_image(self, file_path: str) -> Tuple[bytes, str]:
        """Retrieve chart image data and content type"""
        pass
    
    @abstractmethod
    async def generate_thumbnail(
        self, 
        original_path: str, 
        output_path: str,
        dimensions: Tuple[int, int] = (300, 300)
    ) -> str:
        """Generate and save thumbnail version"""
        pass
    
    @abstractmethod
    async def delete_file(self, file_path: str) -> bool:
        """Delete a stored file"""
        pass
    
    @abstractmethod
    def generate_file_path(
        self, 
        user_id: UUID, 
        extension: str
    ) -> str:
        """Generate storage path for a new file"""
        pass