# src/config.py
from pydantic import ConfigDict
from pydantic_settings import BaseSettings


class Settings(BaseSettings):
    DATABASE_URL: str = "postgresql+psycopg://chart_analyzer_user:chartanalyzer13@localhost:5432/chart_analyzer"
    JWT_SECRET: str = "zKReJQaoTK_F9Y2EIkDKZS1hgnfOZsplgzbjXY7IWyc"
    JWT_ALGORITHM: str = "HS256"
    JWT_EXPIRE_MINUTES: int = 30
    
    # LLM Service Configuration
    OLLAMA_HOST: str = "http://localhost:11434"
    OLLAMA_MODEL: str = "llava:34b"
    CHARTGEMMA_GRADIO_URL: str = "https://c55d0e06f974d4ba67.gradio.live/"
    DEFAULT_LLM_MODEL: str = "ollama"

    # Use model_config instead of inner Config class
    model_config = ConfigDict(
        env_file=".env",
        env_file_encoding="utf-8",
        extra="ignore"  # or "allow" if you want to allow extra fields
    )

settings = Settings()