from pydantic import BaseModel
from datetime import datetime, timezone
from typing import Optional

class ChartImage(BaseModel):
    id: str  # UUID
    user_id: str  # Owner of the chart
    file_path: Optional[str] = None  # File path for filesystem storage (registered users)
    image_data: Optional[bytes] = None  # Direct image data for one-time analysis
    #thumbnail_path: Optional[str] = None  # Optional thumbnail path
    uploaded_at: datetime = datetime.now(timezone.utc)
    
    def get_image_bytes(self) -> bytes:
        """Get image bytes either from file or direct data"""
        if self.image_data:
            return self.image_data
        elif self.file_path:
            with open(self.file_path, 'rb') as f:
                return f.read()
        else:
            raise ValueError("No image data available")