from src.domain.entities.chart_analysis import ChartAnalysis
from src.domain.ports.repositories.analysis_repository import AnalysisRepositoryPort
from src.application.dtos.LLM import LLMResponseDTO
import uuid
from datetime import datetime, timezone

class SaveAnalysisUseCase:
    def __init__(self, analysis_repo: AnalysisRepositoryPort):
        self._analysis_repo = analysis_repo

    def execute(self, chart_image_id: str, question: str, llm_response: LLMResponseDTO) -> ChartAnalysis:
        """Save analysis result to database for history tracking"""
        analysis = ChartAnalysis(
            id=str(uuid.uuid4()),
            chart_image_id=chart_image_id,
            question=question,
            answer=llm_response.answer,
            created_at=datetime.now(timezone.utc)
        )
        
        self._analysis_repo.save_analysis(analysis)
        return analysis 