from pydantic import BaseModel
from datetime import datetime, timezone
from typing import List, Optional

class ConversationMessage(BaseModel):
    id: str
    conversation_id: str
    user_id: str
    message_type: str  # "user" or "assistant"
    content: str
    timestamp: datetime = datetime.now(timezone.utc)

class Conversation(BaseModel):
    id: str
    user_id: str
    chart_image_id: str
    title: str
    created_at: datetime = datetime.now(timezone.utc)
    updated_at: datetime = datetime.now(timezone.utc)
    is_active: bool = True
    messages: List[ConversationMessage] = [] 