// src/components/ProtectedRoute.tsx
import type { ReactNode } from 'react';
import { Navigate, useLocation } from 'react-router-dom';
import { useAuth } from '../contexts/AuthContext';

interface ProtectedRouteProps {
  children: ReactNode;
  /**
   * Optional redirect path (defaults to '/login')
   */
  redirectTo?: string;
}

export const ProtectedRoute = ({ 
  children, 
  redirectTo = '/auth/login' 
}: ProtectedRouteProps) => {
  const { isAuthenticated } = useAuth();
  const location = useLocation();

  if (!isAuthenticated) {
    return (
      <Navigate 
        to={redirectTo} 
        replace 
        state={{ from: location }}  // Preserve navigation history
      />
    );
  }

  return <>{children}</>;
};