from sqlalchemy.sql import func
from sqlalchemy.orm import declarative_base
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
import uuid

class ChartAnalysisModel(Base, TimestampMixin):
    __tablename__ = 'chart_analysis'
    
    id = Column(UUID(as_uuid=True), primary_key=True, default=uuid4)
    chart_image_id = Column(UUID(as_uuid=True), ForeignKey('chart_images.id'), nullable=False)
    question = Column(Text, nullable=False)
    answer = Column(Text, nullable=False)
    metadata = Column(JSONB)  # Added for additional analysis data
    
    # Relationship
    chart_image = relationship("ChartImageModel", back_populates="analysis")
