from abc import ABC, abstractmethod
from src.application.dtos.authentication import (
    RegisterRequestDTO,
    LoginRequestDTO,
    UserResponseDTO,
    TokenResponseDTO
)

class AuthServicePort(ABC):
    @abstractmethod
    async def register(self, register_dto: RegisterRequestDTO) -> UserResponseDTO:
        """
        Register a new user with email and password
        :param register_dto: RegisterRequestDTO containing email and password
        :return: UserResponseDTO containing user details
        """
        ...

    @abstractmethod
    async def login(self, login_dto: LoginRequestDTO) -> TokenResponseDTO:
        """
        Authenticate user and return JWT token
        :param login_dto: LoginRequestDTO containing email and password
        :return: TokenResponseDTO containing access token
        """
        ...

    @abstractmethod
    async def logout(self, token: str) -> None:
        """
        Invalidate a JWT token
        :param token: JWT token to invalidate
        """
        ...

    @abstractmethod
    async def validate_token(self, token: str) -> bool:
        """
        Validate if a JWT token is still valid
        :param token: JWT token to validate
        :return: Boolean indicating token validity
        """
        ...