from pydantic import BaseModel
from typing import List, Optional

class CreateConversationRequestDTO(BaseModel):
    chart_image_id: str
    title: str

class SendMessageRequestDTO(BaseModel):
    conversation_id: str
    message: str

class ConversationResponseDTO(BaseModel):
    id: str
    title: str
    created_at: str
    updated_at: str
    message_count: int

class MessageResponseDTO(BaseModel):
    id: str
    message_type: str
    content: str
    timestamp: str

class ConversationDetailResponseDTO(BaseModel):
    id: str
    title: str
    created_at: str
    updated_at: str
    messages: List[MessageResponseDTO] 