from sqlalchemy import Column, String, DateTime, Boolean, Text, ForeignKey
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
from src.infrastructure.persistence.models.base import Base
from datetime import datetime, timezone
class ConversationModel(Base, TimestampMixin):
    __tablename__ = "conversations"
    
    id = Column(UUID(as_uuid=True), primary_key=True, default=uuid4)
    user_id = Column(UUID(as_uuid=True), ForeignKey('users.id'), nullable=False)
    chart_image_id = Column(UUID(as_uuid=True), ForeignKey('chart_images.id'), nullable=True)
    title = Column(String(255), nullable=False)
    is_active = Column(Boolean, default=True)
    
    # Relationships
    user = relationship("UserModel", back_populates="conversations")
    chart_image = relationship("ChartImageModel", back_populates="conversations")
    messages = relationship("ConversationMessageModel", back_populates="conversation", 
                          cascade="all, delete-orphan")

class ConversationMessageModel(Base):
    __tablename__ = "conversation_messages"
    
    id = Column(UUID(as_uuid=True), primary_key=True, default=uuid4)
    conversation_id = Column(UUID(as_uuid=True), ForeignKey("conversations.id"), nullable=False)
    message_type = Column(String(20), nullable=False)  # 'user' or 'assistant'
    content = Column(Text, nullable=False)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    metadata = Column(JSONB)  # For additional message data
    
    # Relationship
    conversation = relationship("ConversationModel", back_populates="messages")