// src/router.tsx
import { createBrowserRouter } from 'react-router-dom';
import { Login } from '../pages/Auth/Login';
import { Register } from '../pages/Auth/Register';
import { AskQuestion } from '../pages/Charts/AskQuestion';
import { AnalyzeChart } from '../pages/Charts/AnalyzeChart';
import { Home } from '../pages/Home';
import { ChatInterface } from '../components/ChatInteface';
import { ProtectedRoute } from '../components/ProtectedRoute';

export const router = createBrowserRouter([
  {
    path: '/',
    element: <Home />,
  },
  {
    path: '/auth/login',
    element: <Login />,
  },
  {
    path: '/auth/register',
    element: <Register />,
  },
  {
    path: '/charts/ask',
    element: (
      <ProtectedRoute>
        <AskQuestion />
      </ProtectedRoute>
    ),
  },
  {
    path: '/charts/analyze',
    element: (
      <ProtectedRoute>
        <AnalyzeChart />
      </ProtectedRoute>
    ),
  },
  {
    path: '/charts/chat',
    element: (
      <ProtectedRoute>
        <ChatInterface />
      </ProtectedRoute>
    ),
  },
  // Add a fallback 404 page
  {
    path: '*',
    element: <div>Page Not Found</div>,
  },
  
]);