## Contributing

There are many ways you can contribute to the development of the **mini.css** framework:

- If you encounter any **bugs**, please open an [issue](https://github.com/Chalarangelo/mini.css/issues/new). Try to include as much information possible, including but not limited to **detailed explanation, screenshots, operating system, browser and device**.
- **Feature requests** are a bit more complicated to process, as we need to get some community feedback on what is worth adding to the framework, but feel free to open an [issue](https://github.com/Chalarangelo/mini.css/issues/new) and we'll have a nice discussion.
- **Flavor files** are always welcome, even if they are just a simple palette change of the default flavor. Feel free to create a [pull request](https://github.com/Chalarangelo/mini.css/compare) if you are a flavor creator.
- **New features** developed can also be submitted as a [pull request](https://github.com/Chalarangelo/mini.css/compare) and, after we receive some community feedback and there's some productive discussion, they might get added to the framework.
- For **third-party-libraries** and other features (such as new modules, components or Javascript libraries) developed for **mini.css**, please feel free to email me (chalarangelo@gmail.com) and we'll take it from there.
- If you create **content that uses or showcases the framework** (Codepens, tutorials, videos or even a cool website or app), email me (chalarangelo@gmail.com) a link to your content, so that I can help you share it with the world.
- For anything **not included in this list**, either open an [issue](https://github.com/Chalarangelo/mini.css/issues/new) or send me an email (chalarangelo@gmail.com).
