# src/infrastructure/database/models.py
from sqlalchemy import Column, String, Boolean, DateTime, LargeBinary, ForeignKey, Text
from sqlalchemy.sql import func
from sqlalchemy.orm import declarative_base
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
import uuid


class ChartImageModel(Base, TimestampMixin):
    __tablename__ = 'chart_images'
    
    id = Column(UUID(as_uuid=True), primary_key=True, default=uuid4)
    user_id = Column(UUID(as_uuid=True), ForeignKey('users.id'), nullable=False)
    file_path = Column(String(512), nullable=False)  # Changed from image_data to file_path
    thumbnail_path = Column(String(512), nullable=True)
    
    # Relationships
    user = relationship("UserModel", back_populates="chart_images")
    analysis = relationship("ChartAnalysisModel", back_populates="chart_image")
    conversations = relationship("ConversationModel", back_populates="chart_image")
