# src/infrastructure/database/models.py
from sqlalchemy import Column, String, Boolean, DateTime, LargeBinary, ForeignKey, Text
from sqlalchemy.sql import func
from sqlalchemy.orm import declarative_base
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
import uuid


class ChartImage(Base):
    __tablename__ = 'chart_images'
    
    id = Column(UUID(as_uuid=True), primary_key=True, default=uuid.uuid4)
    user_id = Column(UUID(as_uuid=True), ForeignKey('users.id'), nullable=False)
    image_data = Column(LargeBinary, nullable=False)  # For storing binary data
    uploaded_at = Column(DateTime(timezone=True), server_default=func.now())
    
    # Relationship
    analyses = relationship("ChartAnalysis", back_populates="chart_image")
    
    def __repr__(self):
        return f"<ChartImage(id={self.id}, user_id={self.user_id})>"