from sqlalchemy.sql import func
from sqlalchemy.orm import declarative_base
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
import uuid

class ChartAnalysis(Base):
    __tablename__ = 'chart_analyses'
    
    id = Column(UUID(as_uuid=True), primary_key=True, default=uuid.uuid4)
    chart_image_id = Column(UUID(as_uuid=True), ForeignKey('chart_images.id'), nullable=False)
    question = Column(Text, nullable=False)
    answer = Column(Text, nullable=False)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    
    # Relationship
    chart_image = relationship("ChartImage", back_populates="analyses")
    
    def __repr__(self):
        return f"<ChartAnalysis(id={self.id}, chart_image_id={self.chart_image_id})>"
