from sqlalchemy import Column, String, DateTime, Boolean, Text, ForeignKey
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.postgresql import UUID
from src.infrastructure.persistence.models.base import Base
from datetime import datetime, timezone

class ConversationModel(Base):
    """SQLAlchemy model for conversations"""
    __tablename__ = "conversations"

    id = Column(UUID(as_uuid=True), primary_key=True)
    user_id = Column(UUID(as_uuid=True), nullable=False)
    chart_image_id = Column(UUID(as_uuid=True), nullable=False)
    title = Column(String(255), nullable=False)
    created_at = Column(DateTime(timezone=True), default=lambda: datetime.now(timezone.utc))
    updated_at = Column(DateTime(timezone=True), default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))
    is_active = Column(Boolean, default=True)

    # Relationship to messages
    messages = relationship("ConversationMessageModel", back_populates="conversation", cascade="all, delete-orphan")

class ConversationMessageModel(Base):
    """SQLAlchemy model for conversation messages"""
    __tablename__ = "conversation_messages"

    id = Column(UUID(as_uuid=True), primary_key=True)
    conversation_id = Column(UUID(as_uuid=True), ForeignKey("conversations.id"), nullable=False)
    user_id = Column(UUID(as_uuid=True), nullable=False)
    message_type = Column(String(20), nullable=False)  # 'user' or 'assistant'
    content = Column(Text, nullable=False)
    timestamp = Column(DateTime(timezone=True), default=lambda: datetime.now(timezone.utc))

    # Relationship to conversation
    conversation = relationship("ConversationModel", back_populates="messages") 