# src/infrastructure/adapters/sqlserver/mappers/mappers.py
from src.domain.entities.user import User as UserEntity
from src.infrastructure.adapters.sqlserver.models import User as UserModel

def user_model_to_entity(model: UserModel) -> UserEntity:
    return UserEntity(
        id=str(model.id),
        email=model.email,
        password_hash=model.password_hash,
        is_active=model.is_active,
        created_at=model.created_at,
        last_login=model.last_login
    )

def user_entity_to_model(entity: UserEntity) -> UserModel:
    return UserModel(
        id=entity.id,
        email=entity.email,
        password_hash=entity.password_hash,
        is_active=entity.is_active,
        created_at=entity.created_at,
        last_login=entity.last_login
    )