from fastapi import FastAPI
from src.infrastructure.api.fastapi.routes import auth, charts
from fastapi.middleware.cors import CORSMiddleware

from sqlalchemy import create_engine
from sqlalchemy.exc import OperationalError

app = FastAPI(debug = "True",
    title="Chart Analyzer API",
    description="API for analyzing charts and managing users.",
    version="1.0.0",
)

@app.on_event("startup")
async def startup_event():
    engine = create_engine("postgresql+psycopg://chart_analyzer_user:chartanalyzer13@localhost:5432/chart_analyzer")
    try:
        with engine.connect() as conn:
            print("✅ Database connection successful")
            print(f"🔗 Connection string: postgresql+psycopg://chart_analyzer_user:chartanalyzer13@localhost:5432/chart_analyzer")
    except OperationalError as e:
        print("❌ Database connection failed")
        print(f"Error: {e}")

# Configure CORS
app.add_middleware(
    CORSMiddleware,
    allow_origins=["http://localhost:5173"],  # Your Vite frontend URL
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)


app.include_router(auth.router, prefix="/auth")
app.include_router(charts.router, prefix="/charts")

@app.get("/")
async def root():
    return {"message": "Welcome to Chart Analyzer"}
