package main_pipeline;

import benefit_classes.LineSequence;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;

public class Producer implements Runnable {
    private final BlockingQueue<LineSequence> inputQueue;
    private final String inputFilePath;

    public Producer(BlockingQueue<LineSequence> inputQueue, String inputFilePath) {
        this.inputQueue = inputQueue;
        this.inputFilePath = inputFilePath;
    }

    @Override
    public void run() {
        int sequence = 1;
        // Read lines from file and add to queue
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFilePath))) {
            String line;
            while ((line = reader.readLine()) != null) {
                LineSequence lineSequence = new LineSequence(line, sequence);
                inputQueue.put(lineSequence); // Put line into the input queue
                sequence += 1;
            }
            inputQueue.put(new LineSequence("EOF", sequence));
        } catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}
