package benefit_classes;

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class DESAlgorithm {
    private SecretKey secretKey;

    public DESAlgorithm(String encodedKey) {                 // The common encodedKey is: fzI0SlHWAfc=
        // decode the base64 encoded string
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        // rebuild key using SecretKeySpec
        secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "DES");
    }

    public String encryption(String text) throws NoSuchPaddingException, NoSuchAlgorithmException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        Cipher desCipher = Cipher.getInstance("DES");
        desCipher.init(Cipher.ENCRYPT_MODE, secretKey);
        byte[] textEncrypted = desCipher.doFinal(text.getBytes("UTF-8"));
        return Base64.getEncoder().encodeToString(textEncrypted);
    }

    public String decryption(String text) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        Cipher desCipher = Cipher.getInstance("DES");
        desCipher.init(Cipher.DECRYPT_MODE, secretKey);
        byte[] textDecrypted = desCipher.doFinal(Base64.getDecoder().decode(text));
        return new String(textDecrypted, "UTF-8");
    }
}
