package TextProcessing;

import main_pipeline.Consumer;
import main_pipeline.Producer;
import main_pipeline.TextProcessorConsumer;
import benefit_classes.LineSequence;
import benefit_classes.LineSequenceComparator;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class TextProcessingSystem {
    private final int numberOfTextProcessor;
    public TextProcessingSystem(int numberOfTextProcessor) {
        this.numberOfTextProcessor = numberOfTextProcessor;
    }
    public void  encryption(String inputFilePath, String outputFilePath){
        BlockingQueue<LineSequence> inputQueue = new LinkedBlockingQueue<>();
        BlockingQueue<LineSequence> outputQueue = new PriorityBlockingQueue<>(50, new LineSequenceComparator());

        new Thread(new Producer(inputQueue, inputFilePath)).start();
        for(int i = 0;i<numberOfTextProcessor;i++)
            new Thread(new TextProcessorConsumer(inputQueue, outputQueue, true)).start();
        new Thread(new Consumer(outputQueue, outputFilePath)).start();
    }

    public void decryption(String inputFilePath, String outputFilePath){
        BlockingQueue<LineSequence> inputQueue = new LinkedBlockingQueue<>();
        BlockingQueue<LineSequence> outputQueue = new PriorityBlockingQueue<>(50, new LineSequenceComparator());

        new Thread(new Producer(inputQueue, inputFilePath)).start();
        for(int i = 0;i<numberOfTextProcessor;i++)
            new Thread(new TextProcessorConsumer(inputQueue, outputQueue, false)).start();
        new Thread(new Consumer(outputQueue, outputFilePath)).start();
    }
}
