package main_pipeline;

import benefit_classes.LineSequence;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;

public class Consumer implements Runnable {
    private final BlockingQueue<LineSequence> outputQueue;
    private final String outputFilePath;

    public Consumer(BlockingQueue<LineSequence> outputQueue, String outputFilePath) {
        this.outputQueue = outputQueue;
        this.outputFilePath = outputFilePath;
    }

    @Override
    public void run() {
        int sequence = 1;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath))) {
            while (true) {
                LineSequence result = outputQueue.peek();
                if (result != null && result.getSequence() == sequence) {
                    result = outputQueue.take(); // Retrieve processed line from the output queue
                    sequence += 1;
                    if (result.getLine().equals("EOF")) {
                        break;
                    } else {
                        writer.write(result.getLine()); // Write the result to the output file
                        writer.newLine();
                        writer.flush();
                    }
                }
            }

        } catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}
