package main_pipeline;
import benefit_classes.DESAlgorithm;
import benefit_classes.LineSequence;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.BlockingQueue;

public class TextProcessorConsumer implements Runnable {
    private final BlockingQueue<LineSequence> inputQueue;
    private final BlockingQueue<LineSequence> outputQueue;
    private static boolean fileEnded = false;
    private final boolean typeOfProcess;

    public TextProcessorConsumer(BlockingQueue<LineSequence> inputQueue, BlockingQueue<LineSequence> outputQueue, boolean typeOfProcess) {
        this.inputQueue = inputQueue;
        this.outputQueue = outputQueue;
        this.typeOfProcess = typeOfProcess;
    }

    @Override
    public void run() {
        try {
            DESAlgorithm des = new DESAlgorithm("fzI0SlHWAfc=");
            while (!fileEnded) {
                LineSequence lineSequence = inputQueue.take(); // Retrieve line from the input queue
                if (lineSequence.getLine().equals("EOF")) {
                    fileEnded = true;
                    outputQueue.put(lineSequence);
                    break;
                } else {
                    System.out.println(Thread.currentThread().getName() + "   " + lineSequence.getLine() + "  " + lineSequence.getSequence());
                    // Process the line
                    if (typeOfProcess)
                        lineSequence.setLine(des.encryption(lineSequence.getLine()));
                    else
                        lineSequence.setLine(des.decryption(lineSequence.getLine()));
                    outputQueue.put(lineSequence); // Put the processed line into the output queue
                }
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } catch (NoSuchPaddingException | UnsupportedEncodingException | IllegalBlockSizeException |
                 NoSuchAlgorithmException | BadPaddingException | InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }
}
