import junit.framework.TestCase;
import main_pipeline.Producer;
import benefit_classes.LineSequence;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ProducerTest extends TestCase {
    BlockingQueue<LineSequence> inputQueue = new LinkedBlockingQueue<>();
    Producer producer = new Producer(inputQueue, "C:\\Users\\dell\\Desktop\\Test Text.txt");
    BlockingQueue<LineSequence> actualQueue = new LinkedBlockingQueue<>();
    public void testReadFile() {

        producer.run();

        actualQueue.add(new LineSequence("this is", 1));
        actualQueue.add(new LineSequence("test text", 2));
        actualQueue.add(new LineSequence("EOF", 3));

        for (int i = 0; i < actualQueue.size(); i++) {
            assertEquals(inputQueue.peek().getLine(), actualQueue.peek().getLine());
            assertEquals(inputQueue.peek().getSequence(), actualQueue.peek().getSequence());
            inputQueue.remove();
            actualQueue.remove();
        }
    }
}
