import junit.framework.TestCase;
import main_pipeline.Consumer;
import main_pipeline.Producer;
import benefit_classes.LineSequence;
import benefit_classes.LineSequenceComparator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

import static junit.framework.Assert.assertEquals;

public class ConsumerTest extends TestCase{
    BlockingQueue<LineSequence> inputQueue = new PriorityBlockingQueue<>(50, new LineSequenceComparator());
    Consumer consumer = new Consumer(inputQueue, "C:\\Users\\dell\\Desktop\\Sequence text.txt");
    public void testWriteToFile() throws InterruptedException {

        inputQueue.put(new LineSequence("EOF", 3));
        inputQueue.put(new LineSequence("this is", 1));
        inputQueue.put(new LineSequence("test text", 2));

        consumer.run();

        try (BufferedReader reader = new BufferedReader(new FileReader("C:\\Users\\dell\\Desktop\\Sequence text.txt"))) {
            String line;
            String allText = "";
            while ((line = reader.readLine()) != null) {
                allText += line;
            }
            assertEquals(allText, "this istest text");

        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
