package parallelCounters;

import java.util.ArrayList;
import java.util.List;

import primeCounters.PrimeCounterRunnable;
import worker.WorkPartitioner;
public class ParallelCounter1 {

	public static long findPrimeNumbers(int[] data, int threadCount) {

		List<PrimeCounterRunnable> summers =  new ArrayList<>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

		for (WorkPartitioner.Part part : parts) {
			summers.add(new PrimeCounterRunnable(data,part));
		}

		for (PrimeCounterRunnable SummerRunnable : summers) {
			SummerRunnable.startThread();
		}

		for (PrimeCounterRunnable SummerRunnable : summers) {
			try {
				SummerRunnable.joinThread();
			} catch (InterruptedException e) {
				System.err.println("Thread cannot join!");
			}
		}

		long numberOfPrimeNumbers = 0;
		for (PrimeCounterRunnable summerRunnable : summers) {
			numberOfPrimeNumbers += summerRunnable.getPrimeNumbers();
		}

		return numberOfPrimeNumbers;
	}


}
