package primeCounters;

import primeChecker.PrimeChecker;
import worker.WorkPartitioner.Part;

public class PrimeCounterThread extends Thread{

	PrimeChecker primeChecker = new PrimeChecker();
	private int start;
	private int finish;
	private int[] data;
	private long numberOfPrimeNumbers;
	
	public PrimeCounterThread(int[] data, int start, int finish) {
		this.start = start;
		this.finish = finish;
		this.data = data;
	}

	public PrimeCounterThread(int[] data, Part part) {
	    this(data, part.getStart(), part.getFinish());
	}

	@Override
	public void run() {
		numberOfPrimeNumbers = 0;
		for (int i = start; i < finish; i++) {
			if(primeChecker.isPrime(data[i]))
				numberOfPrimeNumbers += 1;
		}
	}

	public long getPrimeNumbers() {
		return numberOfPrimeNumbers;
	}
	
}