package parallelCounters;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;  
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import primeCounters.PrimeCounterCallable;
import worker.WorkPartitioner;

public class ParallelCounter3 {

	public static long findPrimeNumbers(int[] data, int threadCount) {

		//creating a pool of #threadCount threads  
		ExecutorService executor = Executors.newFixedThreadPool(threadCount);

		List<PrimeCounterCallable> summers =  new ArrayList<PrimeCounterCallable>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

		for (WorkPartitioner.Part part : parts) {
			summers.add(new PrimeCounterCallable(data,part));
		}

		List<Future<Long>> results;
		try {
			results = executor.invokeAll(summers);
		} catch (InterruptedException e) {
			System.err.println("Cannot invoke the threads.");
			return -1;
		}

		executor.shutdown();

		long numberOfPrimeNumbers = 0;
		for (Future<Long> future : results) {
			try {
				numberOfPrimeNumbers += future.get();
			} catch (InterruptedException | ExecutionException e) {
				System.err.println("Cannot get the results from threads.");
				return -2;
			}
		}
		return numberOfPrimeNumbers;
	}

}

