package parallelCounters;


import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import primeCounters.PrimeCounterThread;
import worker.WorkPartitioner;

public class ParallelCounter2 {

	public static long findPrimeNumbers(int[] data, int threadCount) {

		List<PrimeCounterThread> summers =  new ArrayList<>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

		for (WorkPartitioner.Part part : parts) {
			summers.add(new PrimeCounterThread(data,part));
		}

		//creating a pool of 5 threads
		ExecutorService executor = Executors.newFixedThreadPool(threadCount);

		for (PrimeCounterThread summer: summers) {
			executor.execute(summer);
		}

		executor.shutdown();

		//Waiting for all the thread to finalize
		while (!executor.isTerminated()) {
			//System.out.println("Processing....");
		}

	    return summers.stream().mapToLong(PrimeCounterThread::getPrimeNumbers).sum();
	}


}
