package parallelCounters;


import java.util.ArrayList;
import java.util.List;

import primeCounters.PrimeCounterThread;
import worker.WorkPartitioner; 

public class ParallelCounter0 {

	public static long findPrimeNumbers(int[] data, int threadCount) {
		
		List<PrimeCounterThread> summers =  new ArrayList<>();
		List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

		for (WorkPartitioner.Part part : parts) {
			summers.add(new PrimeCounterThread(data,part));
		}
		
		for (PrimeCounterThread summerThread : summers) {
			summerThread.start();
		}
		
		for (PrimeCounterThread summerThread : summers) {
			try {
				summerThread.join();
			} catch (InterruptedException e) {
				System.err.println("Thread cannot join!");
			}
		}

		long numberOfPrimeNumbers = 0;
		for (PrimeCounterThread summerThread : summers) {
//			System.out.println(summerThread.getPrimeNumbers());
			numberOfPrimeNumbers += summerThread.getPrimeNumbers();
		}

		return numberOfPrimeNumbers;
	}

	
}
