import static org.junit.jupiter.api.Assertions.*;

import data.RangeArrayBuilder;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import parallelCounters.*;

class ParallelCountersTest {
	private static int start;
	private static int finish;
	private static int[] data;
	private static long result;
	
	@BeforeAll
	public static void initialize() {
		start = 0;
		finish = 1000;
		data = RangeArrayBuilder.create(start, finish);
		result = SequentialCounter.findPrimeNumbers(data);
	}
	
	private static void testAll(int threadCount) {
		long startTime = System.currentTimeMillis();

		long actualResult0 = ParallelCounter0.findPrimeNumbers(data,threadCount);
		long actualResult1 = ParallelCounter1.findPrimeNumbers(data,threadCount);
		long actualResult2 = ParallelCounter2.findPrimeNumbers(data,threadCount);
		long actualResult3 = ParallelCounter3.findPrimeNumbers(data,threadCount);
		long actualResult4 = ParallelCounter4.findPrimeNumbers(data,threadCount);

		long endTime = System.currentTimeMillis() - startTime;

		assertEquals(result, actualResult0);
		assertEquals(result, actualResult1);
		assertEquals(result, actualResult2);
		assertEquals(result, actualResult3);
		assertEquals(result, actualResult4);

		System.out.println("Expected Result: " + result);
		System.out.println("Actual Result in Parallel Counter 0: " + actualResult0);
		System.out.println("Actual Result in Parallel Counter 1: " + actualResult1);
		System.out.println("Actual Result in Parallel Counter 2: " + actualResult2);
		System.out.println("Actual Result in Parallel Counter 3: " + actualResult3);
		System.out.println("Actual Result in Parallel Counter 4: " + actualResult4);
		System.out.println("Execute Time: " + endTime);

	}
	
	@Test
	void testSingleThread() {
		testAll(1);
	}
	
	@Test
	void testTwoThread() {
		testAll(2);
	}
	
	@Test
	void testFourThread() {
		testAll(4);
	}
	
	@Test
	void testEightThread() {
		testAll(8);
	}
	
	@Test
	void testSixteenThread() {
		testAll(16);
	}


}
