package primeCounters;

import primeChecker.PrimeChecker;
import worker.WorkPartitioner.Part;

/**
 * {@link Runnable} based {@link PrimeCounter ).
 *
 * @author Ahmet Cengizhan Dirican
 * @see https://github.com/acdirican
 */
public class PrimeCounterRunnable extends PrimeCounter implements Runnable{

	PrimeChecker primeChecker = new PrimeChecker();
	private Thread thread;

	public PrimeCounterRunnable(int[] data, Part part) {
		super(data, part);
	}

	@Override
	public void run() {
		numberOfPrimeNumbers = 0;
		for (int i = start; i < finish; i++) {
			if(primeChecker.isPrime(data[i]))
				numberOfPrimeNumbers += 1;
		}
	}

	public void startThread() {
		thread =  new Thread(this);
		thread.start();
	}

	public void joinThread() throws InterruptedException {
		thread.join();
	}
}