package primeCounters;
import java.util.concurrent.Callable;

import primeChecker.PrimeChecker;
import worker.WorkPartitioner.Part;

/**
 * {@link Callable} based {@link PrimeCounter ).
 *
 * @author Ahmet Cengizhan Dirican
 * @see https://github.com/acdirican
 */
public class PrimeCounterCallable extends PrimeCounter implements Callable<Long> {

	PrimeChecker primeChecker = new PrimeChecker();
	public PrimeCounterCallable(int[] data, Part part) {
		super(data, part);
	}

	@Override
	public Long call() throws Exception {
		numberOfPrimeNumbers = 0;
		for (int i = start; i < finish; i++) {
			if(primeChecker.isPrime(data[i]))
				numberOfPrimeNumbers += 1;
		}
		return numberOfPrimeNumbers;
	}


}