import java.util.ArrayList;
import java.util.List;

public class ThreadPool
{
    MyBlockingQueue<Runnable> taskqueue = null;
    List<PoolThreadRunnable> threads = new ArrayList<PoolThreadRunnable>();
    boolean isStopped = false;

    public ThreadPool(int n_threads, int q_size)
    {
        this.taskqueue = new MyBlockingQueue<>(q_size);

        for(int i = 0; i<n_threads; i++)
        {
            PoolThreadRunnable thread = new PoolThreadRunnable(taskqueue);
            threads.add(thread);
        }

        for (PoolThreadRunnable thread: threads)
        {
            new Thread(thread).start();
        }
    }

    public synchronized void execute(Runnable task) throws Exception
    {
        if(isStopped)
                throw new IllegalStateException("thread is stopped");

        taskqueue.Enqueue(task);
    }

    public synchronized void Stop()
    {
        isStopped = true;

        for(PoolThreadRunnable thread: threads)
        {
            thread.Stop();
        }
    }

    public synchronized void Wait_Xms_UntillAllTasksFinished(int duration_ms)
    {
        if(taskqueue.Size() > 0)
        {
            try
            {
                Thread.sleep(duration_ms);
            }
            catch (InterruptedException e)
            {
                System.out.println(e.getStackTrace());
            }
        }
    }



}
