public class PoolThreadRunnable implements Runnable
{
    Thread thread = null;
    MyBlockingQueue<Runnable> taskqueue = null;
    boolean isStopped = false;

    public PoolThreadRunnable(MyBlockingQueue queue)
    {
        taskqueue = queue;
    }
    @Override
    public void run()
    {
        this.thread = Thread.currentThread();

        while (!isStopped)
        {
            try
            {
                Runnable task = taskqueue.dequeue();
                task.run();
            }
            catch (InterruptedException e)
            {
                //do nothing,,, cause task might be null
            }
        }
    }

    public synchronized void Stop()
    {
        isStopped = true;
        this.thread.interrupt();
    }

    public synchronized boolean isStopped()
    {
        return isStopped;
    }
}
