import java.util.LinkedList;
import java.util.Queue;

public class MyBlockingQueue <T>
{
    private Queue<T> queue;
    private int Q_Size;

    public MyBlockingQueue(int q_Size)
    {
        queue = new LinkedList<>();
        this.Q_Size = q_Size;
    }

    public synchronized void Enqueue(T element) throws InterruptedException
    {
        while(queue.size() == Q_Size)
        {
            wait();
        }
        queue.offer(element);
        notify();
    }

    public synchronized T dequeue() throws InterruptedException
    {
        while(queue.isEmpty())
        {
            wait();
        }
        T element = queue.poll();
        notify();
        return element;
    }

    public synchronized int Size()
    {
        return queue.size();
    }
}
