import Data.Data;
import Organizer.*;
import org.junit.BeforeClass;
import org.junit.Test;

import static junit.framework.TestCase.assertEquals;

public class OrganizersTest
{
    private static int size;
    private static int[] data;
    private static int result;

    @BeforeClass
    public static void initialize() {
        size = 10;
        data = Data.createData(size);
        result = SequentialCounter.Count(data);
    }

    private static void testAll(int threadCount) {

        assertEquals(result, Organizer_1.Count(data,threadCount));
        assertEquals(result, Organizer_2.Count(data,threadCount));
        assertEquals(result, Organizer_3.Count(data,threadCount));
        assertEquals(result, Organizer_4.Count(data,threadCount));
        assertEquals(result, Organizer_5.Count(data,threadCount));
    }

    @Test
    public void testSingleThread() {
        testAll(1);
    }

    @Test
    public void testTwoThread() {
        testAll(2);
    }

    @Test
    public void testFourThread() {
        testAll(4);
    }

    @Test
    public void testEightThread() {
        testAll(8);
    }

    @Test
    public void testSixteenThread() {
        testAll(16);
    }
}
