package Organizer;

import Data.DataPart;
import PrimeNumberCounter.PrimeNumberCounterCallable;
import Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

//this class represent one type of the foreman or literally the organizer
//it is the class that organize (split and distribute the data to the workers (threads) and aggregate the results )
public class Organizer_5
{
    public static int Count(int[] data, int threadCount)
    {

        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        List<Future<Integer>> results = new ArrayList<Future<Integer>>();
        List<DataPart> parts = WorkPartitioner.partitions(data.length, threadCount);

        for (DataPart part : parts)
        {
            results.add(executor.submit(new PrimeNumberCounterCallable(part, data)));
        }

        executor.shutdown();

        while (!executor.isTerminated())
        {
            //System.out.println("Processing...");
        }

        int count = 0;
        for (Future<Integer> future : results)
        {
            try
            {
                count += future.get();
            }
            catch (InterruptedException | ExecutionException e)
            {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }

        return count;
    }
}
