package Organizer;

import Data.DataPart;
import PrimeNumberCounter.PrimeNumberCounterCallable;
import Worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

//this class represent one type of the foreman or literally the organizer
//it is the class that organize (split and distribute the data to the workers (threads) and aggregate the results )
public class Organizer_4
{
    public static int Count(int[] data, int threadCount)
    {

        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        List<PrimeNumberCounterCallable> primeNumberCounters = new ArrayList<PrimeNumberCounterCallable>();
        List<DataPart> parts = WorkPartitioner.partitions(data.length, threadCount);

        for (DataPart part : parts)
        {
            primeNumberCounters.add(new PrimeNumberCounterCallable(part, data));
        }

        List<Future<Integer>> results;
        try
        {
            results = executor.invokeAll(primeNumberCounters);
        }
        catch (InterruptedException e)
        {
            System.err.println("Cannot invoke the threads.");
            return -1;
        }

        executor.shutdown();

        int count = 0;
        for (Future<Integer> future : results)
        {
            try
            {
                count += future.get();
            }
            catch (InterruptedException | ExecutionException e)
            {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }
        return count;
    }
}
